<?php

/**
 * Theme Name: Minimalist
 * Theme URI: https://example.com/minimalist-theme/
 * Author: Claude
 * Author URI: https://anthropic.com/
 * Description: A clean, lightweight, and minimalist WordPress theme
 * Version: 1.0
 * License: GNU General Public License v2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: minimalist
 * Tags: minimalist, clean, simple, responsive, light, white
 */

// Theme setup
function minimalist_setup()
{
    // Add default posts and comments RSS feed links to head
    add_theme_support('automatic-feed-links');

    // Let WordPress manage the document title
    add_theme_support('title-tag');

    // Enable support for Post Thumbnails on posts and pages
    add_theme_support('post-thumbnails');

    // Register main menu
    register_nav_menus(array(
        'primary' => esc_html__('Primary Menu', 'minimalist'),
    ));

    // Switch default core markup to output valid HTML5
    add_theme_support('html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
    ));

    // Set up the WordPress core custom background feature
    add_theme_support('custom-background', array(
        'default-color' => 'ffffff',
    ));

    // Add theme support for Custom Logo
    add_theme_support('custom-logo', array(
        'height'      => 100,
        'width'       => 300,
        'flex-height' => true,
        'flex-width'  => true,
    ));
}
add_action('after_setup_theme', 'minimalist_setup');

// Register widget area
function minimalist_widgets_init()
{
    register_sidebar(array(
        'name'          => esc_html__('Sidebar', 'minimalist'),
        'id'            => 'sidebar-1',
        'description'   => esc_html__('Add widgets here.', 'minimalist'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
}
add_action('widgets_init', 'minimalist_widgets_init');

// Enqueue scripts and styles
function minimalist_scripts()
{
    wp_enqueue_style('minimalist-style', get_stylesheet_uri(), array(), '1.0.0');
    wp_enqueue_script('minimalist-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '1.0.0', true);
}
add_action('wp_enqueue_scripts', 'minimalist_scripts');

// Custom template tags for this theme
require get_template_directory() . '/inc/template-tags.php';

// Functions which enhance the theme by hooking into WordPress
require get_template_directory() . '/inc/template-functions.php';
