<?php

/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 */

get_header();
?>

<div class="container">
    <div class="site-content">
        <main id="primary" class="content-area">
            <?php if (have_posts()) : ?>

                <div class="posts-list">

                    <?php
                    /* Start the Loop */
                    while (have_posts()) :
                        the_post();
                    ?>
                        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                            <?php if (has_post_thumbnail()) : ?>
                                <div class="post-thumbnail">
                                    <a href="<?php echo esc_url(get_permalink()); ?>">
                                        <?php the_post_thumbnail('large'); ?>
                                    </a>
                                </div>
                            <?php endif; ?>

                            <div class="post-content-wrapper">
                                <header class="entry-header">
                                    <?php the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>

                                    <div class="entry-meta">
                                        <span class="posted-on"><?php echo get_the_date(); ?></span>
                                        <span class="byline"><?php echo get_the_author(); ?></span>
                                    </div>
                                </header>

                                <div class="entry-content">
                                    <?php the_excerpt(); ?>
                                    <a href="<?php echo esc_url(get_permalink()); ?>" class="read-more"><?php esc_html_e('Read More', 'minimalist'); ?> →</a>
                                </div>

                                <footer class="entry-footer">
                                    <?php
                                    $categories_list = get_the_category_list(', ');
                                    if ($categories_list) {
                                        echo '<span class="cat-links">' . $categories_list . '</span>';
                                    }
                                    ?>
                                </footer>
                            </div>
                        </article>
                    <?php endwhile; ?>

                </div><!-- .posts-list -->

                <div class="pagination-container">
                    <?php the_posts_navigation(); ?>
                </div>

            <?php else : ?>
                <p><?php esc_html_e('No posts found.', 'minimalist'); ?></p>
            <?php endif; ?>
        </main>

        <?php get_sidebar(); ?>
    </div>
</div>

<?php get_footer(); ?>