<?php

/**
 * The template for displaying all single posts
 */

get_header();
?>

<div class="container">
    <div class="site-content">
        <main id="primary" class="content-area">
            <?php
            while (have_posts()) :
                the_post();
            ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
                    <header class="entry-header">
                        <?php the_title('<h1 class="entry-title">', '</h1>'); ?>

                        <div class="entry-meta">
                            <?php
                            echo '<span class="posted-on">' . esc_html__('Posted on', 'minimalist') . ' ' . get_the_date() . '</span>';
                            echo ' <span class="byline">' . esc_html__('by', 'minimalist') . ' ' . get_the_author() . '</span>';
                            ?>
                        </div>
                    </header>

                    <?php if (has_post_thumbnail()) : ?>
                        <div class="post-thumbnail">
                            <?php the_post_thumbnail('large'); ?>
                        </div>
                    <?php endif; ?>

                    <div class="entry-content">
                        <?php
                        the_content(
                            sprintf(
                                wp_kses(
                                    /* translators: %s: Name of current post. Only visible to screen readers */
                                    __('Continue reading<span class="screen-reader-text"> "%s"</span>', 'minimalist'),
                                    array(
                                        'span' => array(
                                            'class' => array(),
                                        ),
                                    )
                                ),
                                wp_kses_post(get_the_title())
                            )
                        );

                        wp_link_pages(
                            array(
                                'before' => '<div class="page-links">' . esc_html__('Pages:', 'minimalist'),
                                'after'  => '</div>',
                            )
                        );
                        ?>
                    </div>

                    <footer class="entry-footer">
                        <?php
                        $categories_list = get_the_category_list(', ');
                        if ($categories_list) {
                            echo '<span class="cat-links">' . esc_html__('Categories: ', 'minimalist') . $categories_list . '</span>';
                        }

                        $tags_list = get_the_tag_list('', ', ');
                        if ($tags_list) {
                            echo ' <span class="tags-links">' . esc_html__('Tags: ', 'minimalist') . $tags_list . '</span>';
                        }
                        ?>
                    </footer>
                </article>

            <?php
                // If comments are open or we have at least one comment, load up the comment template.
                if (comments_open() || get_comments_number()) :
                    comments_template();
                endif;

            endwhile; // End of the loop.
            ?>
        </main>

        <?php get_sidebar(); ?>
    </div>
</div>

<?php
get_footer();
